
DROP TABLE ITEMS_NOTAS;
DROP TABLE NOTAS;
DROP TABLE PRODUTOS;
DROP TABLE CLIENTES;
DROP TABLE VENDEDORES;

CREATE TABLE PRODUTOS
(CODIGO VARCHAR(10) NOT NULL,
DESCRITOR VARCHAR(100) NULL,
SABOR VARCHAR(50) NULL,
TAMANHO VARCHAR(50) NULL,
EMBALAGEM VARCHAR(5) NULL,
PRECO_LISTA FLOAT NULL,
PRIMARY KEY (CODIGO));

CREATE TABLE VENDEDORES
(MATRICULA VARCHAR(5) NOT NULL,
NOME VARCHAR(100) NULL,
BAIRRO VARCHAR(50) NULL,
COMISSAO FLOAT NULL,
DATA_ADIMISSAO DATE NULL,
FERIAS INTEGER NULL,
PRIMARY KEY (MATRICULA));

ALTER TABLE VENDEDORES RENAME COLUMN DATA_ADIMISSAO
TO DATA_ADMISSAO;

 CREATE TABLE CLIENTES 
   (	CPF VARCHAR2(11 BYTE) NOT NULL, 
	NOME VARCHAR2(100 BYTE) NULL, 
	ENDERECO VARCHAR2(150 BYTE) NULL, 
	BAIRRO VARCHAR2(50 BYTE) NULL, 
	CIDADE VARCHAR2(50 BYTE) NULL, 
	ESTADO VARCHAR2(50 BYTE) NULL, 
	CEP VARCHAR2(8 BYTE) NULL, 
	DATA_NASCIMENTO DATE NULL, 
	IDADE NUMBER(*,0) NULL, 
	SEXO VARCHAR2(1 BYTE) NULL, 
	LIMITE_CREDITO FLOAT(126) NULL, 
	VOLUME_COMPRA FLOAT(126) NULL, 
	PRIMEIRA_COMPRA NUMBER(*,0) NULL,
	PRIMARY KEY (CPF)
   );
   
  
CREATE TABLE NOTAS
(NUMERO VARCHAR(5) NOT NULL,
DATA_VENDA DATE NULL,
CPF VARCHAR(11) NOT NULL,
MATRICULA VARCHAR(5) NOT NULL,
IMPOSTO FLOAT NULL,
PRIMARY KEY(NUMERO));

ALTER TABLE NOTAS
ADD CONSTRAINT FK_CLIENTES
FOREIGN KEY (CPF) REFERENCES CLIENTES (CPF);

ALTER TABLE NOTAS
ADD CONSTRAINT FK_VENDEDORES
FOREIGN KEY (MATRICULA) REFERENCES VENDEDORES (MATRICULA);


CREATE TABLE ITEMS_NOTAS
(NUMERO VARCHAR(5) NOT NULL,
CODIGO VARCHAR(10) NOT NULL,
QUANTIDADE INTEGER NULL,
PRECO FLOAT NULL,
PRIMARY KEY (NUMERO, CODIGO));

ALTER TABLE ITEMS_NOTAS ADD CONSTRAINT FK_NOTAS
FOREIGN KEY (NUMERO) REFERENCES NOTAS (NUMERO);

ALTER TABLE ITEMS_NOTAS ADD CONSTRAINT FK_PRODUTOS
FOREIGN KEY (CODIGO) REFERENCES PRODUTOS (CODIGO);




 